
#define timedateinclude

typedef struct tyinternationalinfo {
	char * longDaysOfWeek[10];
	char * shortDaysOfWeek[10];
	char * longMonths[13];
	char * shortMonths[13];
	char * longYears[12];		//Year descriptions
	char * morning;
	char * evening;
	char * military;
	char * currency;			//for the US this is $
	char * intlCurrency;		//for the US this is USD
	char * shortDateFormatPattern;
	char * longDateFormatPattern;
	char * decimal;
	char * thousands;
	char * list;
	char * timesep;
	char * datesep;
	short numberOfDays;			//Usally 7 plus 3 for Yesterday, Today, and Tomorrow
	short numberOfMonths;
	short daysInMonth[13];		//For Gregorian calendar February is listed as 28 and corrected in code.
	short numberOfYears;
	boolean defaultTimeFormat;	//false = 12hour
	} tyinternationalinfo, * tyinternationalinfoptr;


/*prototypes*/

extern void timestamp (long *);

extern unsigned long timenow (void);

extern boolean setsystemclock (unsigned long);

extern boolean timegreaterthan (unsigned long, unsigned long);

extern boolean timelessthan (unsigned long, unsigned long);

extern boolean timetotimestring (unsigned long, bigstring, boolean);

extern boolean timetodatestring (unsigned long, bigstring, boolean);

extern boolean stringtotime (bigstring, unsigned long *);

extern long datetimetoseconds (short, short, short, short, short, short);

extern void secondstodatetime (long, short *, short *, short *, short *, short *, short *);

extern void secondstodayofweek (long, short *);

#ifdef WIN95VERSION

extern long filetimetoseconds (const FILETIME *);

extern void secondstofiletime (long seconds, FILETIME *);

#endif

extern unsigned long nextmonth(unsigned long date);

extern unsigned long nextyear(unsigned long date);

extern unsigned long prevmonth(unsigned long date);

extern unsigned long prevyear(unsigned long date);

extern unsigned long firstofmonth(unsigned long date);

extern unsigned long lastofmonth(unsigned long date);

extern short daysInMonth (short month, short year);

extern void shortdatestring (unsigned long date, bigstring bs);

extern void longdatestring (unsigned long date, bigstring bs);

extern void abbrevdatestring (unsigned long date, bigstring bs);

extern void getdaystring (short dayofweek, bigstring bs, boolean flFullname);

extern long getcurrenttimezonebias();

extern boolean isLeapYear (short year);

extern tyinternationalinfoptr getIntlInfo ();
